<?php
/* --------------------------------------------------------------
 GeoZone.php 2020-01-21
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 21 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Core\Configuration\Types;

use Gambio\Core\Configuration\Models\Read\Collections\Options;
use Gambio\Core\Configuration\Repositories\Components\OptionsResolver;
use function array_unshift;

/**
 * Class GeoZone
 * @package Gambio\Core\Configuration\Types
 */
class GeoZone implements ConfigurationType
{
    /**
     * @inheritDoc
     */
    public function toOptions(OptionsResolver $resolver, string $value = null): ?Options
    {
        $none = $resolver->getText('TEXT_NONE', 'admin_general');
        
        $connection = $resolver->connection();
        $query      = 'SELECT `geo_zone_id` as `value`, `geo_zone_name` as `text` FROM `geo_zones` ORDER BY `geo_zone_name`;';
        
        $data = $connection->fetchAll($query);
        array_unshift($data, ['value' => '0', 'text' => $none]);
        
        return Options::fromArray($data);
    }
    
    
    /**
     * @inheritDoc
     */
    public function inputType(): string
    {
        return 'dropdown';
    }
}